using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.BizTalk.Component.Interop;
using System.ComponentModel;
using Microsoft.BizTalk.Message.Interop;
using System.Collections;

namespace Blogical.Shared.PipelineComponents
{
    /// <summary>
    /// Pipeline component that sets AckRequired.
    /// </summary>
    [ComponentCategory(CategoryTypes.CATID_PipelineComponent)]
    [ComponentCategory(CategoryTypes.CATID_Transmitter)]
    [ComponentCategory(CategoryTypes.CATID_Any)]
    [System.Runtime.InteropServices.Guid("17300206-B75B-40d1-B0C0-0A9A5BAFB0A6")]
    public class AkcRequired : IBaseComponent,
                                    Microsoft.BizTalk.Component.Interop.IComponent,
                                    IComponentUI,
                                    IPersistPropertyBag
    {
        #region Public Properties

        private bool _Enabled = true;

        /// <summary>
        /// A switch to determine if we should perform work or not.
        /// </summary>
        [DescriptionAttribute("Switch to enable/disable Component.")]
        public bool Enabled
        {
            get { return _Enabled; }
            set { _Enabled = value; }
        }

        #endregion

        #region IBaseComponent Members

        /// <summary>
        /// Description of component
        /// </summary>
        [Browsable(false)]
        public string Description
        {
            get { return Blogical.Shared.PipelineComponents.Resources.ACKREQUIRED_Description; }
        }

        /// <summary>
        /// Name of component
        /// </summary>
        [Browsable(false)]
        public string Name
        {
            get { return Blogical.Shared.PipelineComponents.Resources.ACKREQUIRED_Name; }
        }

        /// <summary>
        /// Version of component
        /// </summary>
        [Browsable(false)]
        public string Version
        {
            get { return Blogical.Shared.PipelineComponents.Resources.ACKREQUIRED_Version; }
        }

        #endregion

        #region IComponent Members

        /// <summary>
        /// This method triggers when the pipeline component executes.
        /// </summary>
        /// <param name="pContext">Context</param>
        /// <param name="pInMsg">Message</param>
        /// <returns></returns>
        public IBaseMessage Execute(IPipelineContext pContext, IBaseMessage pInMsg)
        {
            if (_Enabled)
            {
                pInMsg.Context.Write(
                    "AckRequired", 
                    "http://schemas.microsoft.com/BizTalk/2003/system-properties", 
                    true);
            }

            return pInMsg;
        }

        #endregion

        #region IComponentUI Members

        /// <summary>
        /// Component icon in toolbar
        /// </summary>
        [Browsable(false)]
        public IntPtr Icon
        {
            get
            {
                return IntPtr.Zero;
            }
        }

        /// <summary>
        /// Validate settings
        /// </summary>
        /// <param name="projectSystem"></param>
        /// <returns></returns>
        public IEnumerator Validate(object projectSystem)
        {
            ArrayList errors = new ArrayList();

            return errors.GetEnumerator();
        }

        #endregion

        #region IPersistPropertyBag Members

        /// <summary>
        /// Return classID
        /// </summary>
        /// <param name="classID"></param>
        public void GetClassID(out Guid classID)
        {
            classID = new Guid("17300206-B75B-40d1-B0C0-0A9A5BAFB0A6");
        }

        /// <summary>
        /// 
        /// </summary>
        public void InitNew()
        {

        }

        /// <summary>
        /// Load settings
        /// </summary>
        /// <param name="propertyBag"></param>
        /// <param name="errorLog"></param>
        public void Load(IPropertyBag propertyBag, int errorLog)
        {
            object val = null;
            try
            {
                propertyBag.Read("Enabled", out val, 0);
            }
            catch { }
            if (val is bool) _Enabled = (bool)val;
        }

        /// <summary>
        /// Save settings
        /// </summary>
        /// <param name="propertyBag"></param>
        /// <param name="clearDirty"></param>
        /// <param name="saveAllProperties"></param>
        public void Save(IPropertyBag propertyBag, bool clearDirty, bool saveAllProperties)
        {
            object val = _Enabled;
            try
            {
                propertyBag.Write("Enabled", ref val);
            }
            catch { }
        }

        #endregion
    }
}
