﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;
using Microsoft.XLANGs.BaseTypes;
using System.IO;
using System.Xml;

namespace LINQHelperLibrary
{
    public class LINQHelper
    {
        public static double GetPOItemSum(XElement po)
        {
            XNamespace aw = "http://www.adventure-works.com";

            return
                (from item in po.Descendants(aw + "Item")
                 select (double)item.Element(aw + "Quantity")
                         * (double)item.Element(aw + "USPrice")
                ).Sum();
        }

        public static double GetItemSumFromBTSMessageBody(XLANGMessage message)
        {
            XmlReader xReader = XmlReader.Create((Stream)message[0].RetrieveAs(typeof(Stream)));
            XElement po = XElement.Load(xReader);
            return GetPOItemSum(po);        
        }

    }
}
