﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Demo.Linq
{
    public delegate TRes MyFunc<TSrc, TRes>(TSrc src);

    public static class Enumerable
    {
        // return a collection of the same type, filtered on predicate
        public static IEnumerable<TSrc> Where<TSrc>(this
            IEnumerable<TSrc> source, MyFunc<TSrc, bool> predicate)
        {
            List<TSrc> res = new List<TSrc>();
            foreach (TSrc s in source)
            {
                if (predicate(s))
                {
                    res.Add(s);
                }
            }
            return res;
        }

        // return a collection of another type
        public static IEnumerable<TRes> Select<TSrc, TRes>(this
            IEnumerable<TSrc> source, MyFunc<TSrc, TRes> selector)
        {
            List<TRes> res = new List<TRes>();
            foreach (TSrc s in source)
            {
                TRes t = selector(s);
                res.Add(t);
            }

            return res;
        }
    }
}
