﻿using System;
using System.Collections.Generic;
using Demo.Linq;

namespace LINQDemo
{
    class Program5
    {
        /// <summary>
        /// Get and display list of Persons over the Age of 30.
        /// With the requirement have an object that contains only Name and Age.
        /// Using Generics and delegates.
        /// </summary>
        /// <param name="args"></param>
        static void Main(string[] args)
        {
            IEnumerable<Person> tmpResults =
                Enumerable.Where<Person>(Person.GetPersons(),
                                new MyFunc<Person, bool>(Helper.MyPredicate)
                                );

            IEnumerable<TempType> results =
                Enumerable.Select<Person, TempType>(tmpResults,
                                new MyFunc<Person, TempType>(Helper.MySelector)
                                );

            foreach (TempType p in results)
            {
                //p.
                Console.WriteLine(p.ToString());
            }

            Console.ReadLine();
        }
    }
}
