﻿using System;
using System.Collections.Generic;
using Demo.Linq;

namespace LINQDemo
{
    class Program7
    {
        /// <summary>
        /// Get and display list of Persons over the Age of 30.
        /// With the requirement have an object that contains only Name and Age.
        /// Using Generics and anonymous delegates. Still only .NET 2.0.
        /// Helper.cs can be skipped.
        /// </summary>
        /// <param name="args"></param>
        static void Main(string[] args)
        {
            IEnumerable<Person> tmpResults =
                Enumerable.Where(Person.GetPersons(),                           
                                //new MyFunc<Person, bool>(Helper.MyPredicate)  // Using anonymous delegates
                                delegate (Person p)
                                {
                                    return p.Age > 30;
                                }
                                );

            IEnumerable<TempType> results =
                Enumerable.Select(tmpResults,                                   
                                //new MyFunc<Person, TempType>(Helper.MySelector) // Same here 
                                delegate (Person p)
                                {
                                    TempType t = new TempType();
                                    t.Name = p.Name;
                                    t.Age = p.Age;
                                    return t;
                                }
                                );

            foreach (TempType p in results)
            {
                //p.
                Console.WriteLine(p.ToString());
            }

            Console.ReadLine();
        }
    }
}
