﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.LiveFX.Client;
using System.Net;

namespace MeshAdapterTestConsole
{
    public class MyData
    {
        public string data;
    }

    class Program
    {
        static void Main(string[] args)
        {
            LiveOperatingEnvironment loe = new LiveOperatingEnvironment();
            loe.Connect(
                new NetworkCredential(Constants.MY_USRNAME, Constants.MY_PASSWD),
                new LiveItemAccessOptions(true)
             );

            MeshObject mo = GetMeshObject(loe);

            DataFeed dataFeed = GetDataFeed(mo);

            AddDataEntry(dataFeed);

            Console.WriteLine("Done.");
            Console.ReadLine();
        }

        private static void AddDataEntry(DataFeed dataFeed)
        {
            MyData data = new MyData();
            data.data = "This is my custom data";

            DataEntry entry = new DataEntry("MeshAdapterEntry");
            entry.Resource.Type = "MeshAdapterItem";
            entry.Resource.SetUserData<string>(@"<?xml version=""1.0"" encoding=""UTF-16""?>"
                + System.Environment.NewLine + "<myXmlElement myFeedNameXmlAttribute=\"MeshAdapterFeed\">This is my data</myXmlElement>");
            dataFeed.DataEntries.Add(ref entry);
            dataFeed.Update();
            entry.Update();
        }

        private static DataFeed GetDataFeed(MeshObject mo)
        {
            var dataFeeds = (from df1 in mo.CreateQuery<DataFeed>()
                             select df1);

            foreach (DataFeed df in dataFeeds)
            {
                mo.DataFeeds.Remove(df);
            }

            DataFeed dataFeed = new DataFeed("MeshAdapterFeed");
            mo.DataFeeds.Add(ref dataFeed);
            mo.Update();

            return dataFeed;
        }

        private static MeshObject GetMeshObject(LiveOperatingEnvironment loe)
        {
            var mos = (from mo1 in loe.Mesh.CreateQuery<MeshObject>()
                       select mo1);

            MeshObject mo = null;
            foreach (MeshObject mo2 in mos)
            {
                if (mo2.Resource.Title == "MeshAdapterObject")
                {
                    mo = mo2;
                    break;
                }
            }

            if (mo == null)
            {
                mo = new MeshObject("MeshAdapterObject");
                mo.Resource.Type = "MeshAdapterObjectType";
                loe.Mesh.MeshObjects.Add(ref mo);
            }
            return mo;
        }
    }
}
