using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.BizTalk.Component.Interop;
using System.Collections;
using Microsoft.BizTalk.Streaming;
using System.Xml;
using System.IO;

namespace RemoveXmlNamespace.PipelineComponents
{
    [ComponentCategory(CategoryTypes.CATID_PipelineComponent)]
    [ComponentCategory(CategoryTypes.CATID_Any)]
    [System.Runtime.InteropServices.Guid("88A3F169-A718-419e-B1DE-7522372E3D03")]
    public class XmlNamespaceRemover : IBaseComponent, IPersistPropertyBag, 
        IComponentUI, Microsoft.BizTalk.Component.Interop.IComponent
    {
        #region IBaseComponent Members

        public string Description
        {
            get { return "Removes XML Namespace"; }
        }

        public string Name
        {
            get { return "XmlNamespaceRemover"; }
        }

        public string Version
        {
            get { return "0.1"; }
        }

        #endregion

        #region IPersistPropertyBag Members

        public void GetClassID(out Guid classID)
        {
            classID = new Guid("88A3F169-A718-419e-B1DE-7522372E3D03");
        }

        public void InitNew()
        {
            
        }

        public void Load(IPropertyBag propertyBag, int errorLog)
        {
           
        }

        public void Save(IPropertyBag propertyBag, bool clearDirty, bool saveAllProperties)
        {
            
        }

        #endregion

        #region IComponentUI Members

        public IntPtr Icon
        {
            get { return IntPtr.Zero; }
        }

        public System.Collections.IEnumerator Validate(object projectSystem)
        {
            return new ArrayList().GetEnumerator();
        }

        #endregion

        #region IComponent Members

        public Microsoft.BizTalk.Message.Interop.IBaseMessage Execute(
            IPipelineContext pContext, 
            Microsoft.BizTalk.Message.Interop.IBaseMessage pInMsg)
        {
            pInMsg.BodyPart.Data = new XmlNamespaceRemoverStream(
                pInMsg.BodyPart.GetOriginalDataStream());
            return pInMsg;
        }

        #endregion
    }

    public class XmlNamespaceRemoverStream : XmlTranslatorStream
    {
        protected override void TranslateStartElement(
            string prefix, string localName, string nsURI)
        {
            base.TranslateStartElement(null, localName, null);
        }

        protected override void TranslateAttribute()
        {
            if (this.m_reader.Prefix != "xmlns")
                base.TranslateAttribute();
        }

        public XmlNamespaceRemoverStream(Stream input)
            : base(new XmlTextReader(input), Encoding.Default)
        { }
    }
}
